unit SensorGroup03;
// ====================================================================
(*
   UNIT SensorGroup03    
     (),   
     ,     
     (UNIT ConsoleMAIN).   
     SensorsToBuffer00()   
   Buffer00   (UNIT Common01)
// -----------------------------------------------------
    3.7. ()  , , , 2017..2020 .
               () Source code  ..
     12.01.2020
*)
// ====================================================================
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls,
  CommonDEF03, CommonDAT03, CommonSRV03, Sensor03;

type
  TSensorGroupForm = class(TForm)
    Panel1: TPanel;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
     //   -    
     procedure SensorChange(Sender : TObject);
     //     
     procedure CloseSensors();
  public
     //      
     function OpenSensors(RqAppInd : integer) : integer;
  end;
// ================================================================
// ================================================================
//    
var  SensorGroupForm: TSensorGroupForm;

// ================================================================
// ================================================================
implementation
{$R *.dfm}
// ================================================================
// ================================================================

// ================================================================
// ----------------------------------------------------------------
//  12.01.2020
//     () .
var CurrAppIndx    : integer;

//       . CurrAppIndx
//   Length(CurrSensorsArr) = 0
var CurrSensorsArr : array of TSensor;

// ================================================================
// ----------------------------------------------------------------
// 09.01.2020
//         
const SnLeft = 10;
      SnTop  = 10;
      SnLen  = 188;
// 09.01.2020
//       
const SensorsDesc : array [0..BufferMaxIndx] of TPoint =
( //  
  ( X : SnLeft + 0 * SnLen; Y : SnTop      ),
  ( X : SnLeft + 0 * SnLen; Y : SnTop + 140),
  ( X : SnLeft + 0 * SnLen; Y : SnTop + 280),
  ( X : SnLeft + 0 * SnLen; Y : SnTop + 420),
  //  
  ( X : SnLeft + 1 * SnLen; Y : SnTop      ),
  ( X : SnLeft + 1 * SnLen; Y : SnTop + 140),
  ( X : SnLeft + 1 * SnLen; Y : SnTop + 280),
  ( X : SnLeft + 1 * SnLen; Y : SnTop + 420),
  //  
  ( X : SnLeft + 2 * SnLen; Y : SnTop      ),
  ( X : SnLeft + 2 * SnLen; Y : SnTop + 140),
  ( X : SnLeft + 2 * SnLen; Y : SnTop + 280),
  ( X : SnLeft + 2 * SnLen; Y : SnTop + 420),
  //  
  ( X : SnLeft + 3 * SnLen; Y : SnTop      ),
  ( X : SnLeft + 3 * SnLen; Y : SnTop + 140),
  ( X : SnLeft + 3 * SnLen; Y : SnTop + 280),
  ( X : SnLeft + 3 * SnLen; Y : SnTop + 420),
  //  
  ( X : SnLeft + 4 * SnLen; Y : SnTop      ),
  ( X : SnLeft + 4 * SnLen; Y : SnTop + 140),
  ( X : SnLeft + 4 * SnLen; Y : SnTop + 280),
  ( X : SnLeft + 4 * SnLen; Y : SnTop + 420),
  //  
  ( X : SnLeft + 5 * SnLen; Y : SnTop      ),
  ( X : SnLeft + 5 * SnLen; Y : SnTop + 140),
  ( X : SnLeft + 5 * SnLen; Y : SnTop + 280),
  ( X : SnLeft + 5 * SnLen; Y : SnTop + 420)
);
// ================================================================
// ----------------------------------------------------------------
// 09.01.2020
//   -    
procedure TSensorGroupForm.SensorChange(Sender : TObject);
var wItem : THeadSensors;
begin
    with (Sender as TSensor)
    do begin
       // --------------------
       //   THeadSensors
       wItem := AllSensorArr[LinkInd1].AppSensorArr[LinkInd2];
       // --------------------
       //    
       wItem.Min     := Min;          //    
       wItem.Max     := Max;          //    
       wItem.Value   := Value;        //    
       wItem.RqNoise := RqNoise;      //   
       wItem.Noise   := Noise;        //  
       // --------------------
       //    
       AllSensorArr[LinkInd1].AppSensorArr[LinkInd2] := wItem;
    end;
end;
// ----------------------------------------------------------------
// 12.01.2020
//     
procedure TSensorGroupForm.CloseSensors();
var Ind : integer;
begin
   CurrAppIndx := -1;  //     
   // --------------------
   //  
   if Length(CurrSensorsArr) = 0 then Exit;
   // --------------------
   //    
   for Ind := Low(CurrSensorsArr) to High(CurrSensorsArr)
   do begin
      if Assigned(CurrSensorsArr[Ind])
      then begin
         CurrSensorsArr[Ind].Free;
      end;
      CurrSensorsArr[Ind] := nil;
   end;
   // --------------------
   //    
   SetLength(CurrSensorsArr,0);
end;
// ----------------------------------------------------------------
// 12.01.2020
//     
function TSensorGroupForm.OpenSensors(RqAppInd : integer) : integer;
var Ind  : integer;
    FW   : Integer;
begin
   Result := -1;
   CurrAppIndx := Result;
   try
      // --------------------
      //     
      CloseSensors();
      // --------------------
      //  
      if (RqAppInd < Low(AllPtScopeArr))  or
         (RqAppInd > High(AllPtScopeArr))
      then Exit;
      if (AllSensorArr[RqAppInd].AppName = '') or
         (Length(AllSensorArr[RqAppInd].AppSensorArr) = 0)
      then Exit;
      // --------------------
      //      
      Caption := '  : ' + AllSensorArr[RqAppInd].AppName;
      // --------------------
      //     
      SetLength(CurrSensorsArr, Length(AllSensorArr[RqAppInd].AppSensorArr));
      //   
      for Ind := Low(CurrSensorsArr) to High(CurrSensorsArr)
      do begin
         with AllSensorArr[RqAppInd].AppSensorArr[Ind]
         do begin
            // ---------------------
            //   
            CurrSensorsArr[Ind] := TSensor.Create(Panel1,
                                                  SensorsDesc[Ind].X,
                                                  SensorsDesc[Ind].Y);
            CurrSensorsArr[Ind].OnSensor := nil;
            // ---------------------
            //    
            CurrSensorsArr[Ind].Indx     := Ind;
            CurrSensorsArr[Ind].Title    := Title;
            CurrSensorsArr[Ind].Min      := Round(Min);
            CurrSensorsArr[Ind].Max      := Round(Max);
            CurrSensorsArr[Ind].RqNoise  := RqNoise;
            CurrSensorsArr[Ind].Noise    := Round(Noise);
            CurrSensorsArr[Ind].Value    := Round(Value);
            CurrSensorsArr[Ind].Color    := clSilver;
            // ---------------------
            //      SensorChange
            CurrSensorsArr[Ind].LinkInd1 := RqAppInd;
            CurrSensorsArr[Ind].LinkInd2 := Ind;
            CurrSensorsArr[Ind].OnSensor := SensorChange;
            // ---------------------
         end;
      end;
      //   
      FW :=  Length(CurrSensorsArr) div 4;
      if Length(CurrSensorsArr) mod 4 > 0 then FW := FW + 1;
      FW := SnLen * FW + SnLeft * 3;
      ClientWidth := FW;
      Result := RqAppInd;
      CurrAppIndx := Result;
   except
      MessageDlg('SensorGroup03.OpenConsole ERROR :'
       + #13#10 + '   ',
                  mtError, [mbOk], 0);
   end;
end;
// ================================================================
//    / 
// ================================================================
// ----------------------------------------------------------------
// 09.01.2020
procedure TSensorGroupForm.FormCreate(Sender: TObject);
begin
//
end;
// ----------------------------------------------------------------
// 09.01.2020
//     
procedure TSensorGroupForm.FormDestroy(Sender: TObject);
begin
   CloseSensors();
end;
// ================================================================
//   
// ================================================================


end.
